﻿using System;

namespace CSharpBuch.Kap13
{
  class Aufgabe4
  {
    private static int richtig = 0;
    private static int falsch = 0;

    public static void RichtigHandler(object sender, EventArgs e)
    {
      richtig++;
    }

    public static void FalschHandler(object sender, EventArgs e)
    {
      falsch++;
    }

    static void Main(string[] args)
    {
      string eingabe;
      string nochmal;

      Rechenaufgabe ra = new Rechenaufgabe();
      ra.Falsch += FalschHandler;
      ra.Richtig += RichtigHandler;

      do
      {
        ra.StelleAufgabe();
        eingabe = Console.ReadLine();
        ra.TesteEingabe(eingabe);
        Console.WriteLine("Noch einmal (Ja / Nein) ?");
        nochmal = Console.ReadLine().ToUpper();
      }
      while (nochmal == "JA");

      Console.WriteLine("{0} Antworten waren richtig, {1} Antworten falsch", richtig, falsch);
      Console.ReadLine();
    }
  }

  public delegate void RichtigFalschEventHandler(object sender, EventArgs e);

  public class Rechenaufgabe
  {
    enum operation { Plus, Mal };
    private int maxZahl = 20;
    private operation op = operation.Plus;
    private Random rd = new Random(DateTime.Now.Millisecond);
    private int richtigesErgebnis;

    public event RichtigFalschEventHandler Richtig;
    public event RichtigFalschEventHandler Falsch;

    protected virtual void OnFalsch(EventArgs e)
    {
      if (Falsch != null)
        Falsch(this, e);
    }

    protected virtual void OnRichtig(EventArgs e)
    {
      if (Richtig != null)
        Richtig(this, e);
    }

    public void StelleAufgabe()
    {
      int zahl1 = rd.Next(maxZahl) + 1;
      int zahl2 = rd.Next(maxZahl) + 1;

      switch (op)
      {
        case operation.Plus: richtigesErgebnis = zahl1 + zahl2; break;
        case operation.Mal: richtigesErgebnis = zahl1 * zahl2; break;
      }

      Console.WriteLine("{0} {1} {2} = ?", zahl1, op, zahl2);

      if (op == operation.Plus)
        op = operation.Mal;
      else
        op = operation.Plus;
    }

    public void TesteEingabe(string wert)
    {
      int eingabe = Int32.Parse(wert);
      if (eingabe == richtigesErgebnis)
      {
        Console.WriteLine("Toll... richtig gerechnet");
        OnRichtig(new EventArgs());
      }
      else
      {
        Console.WriteLine("Da müssen wir wohl noch ein bisschen üben. Richtig war {0}",
                          richtigesErgebnis);
        OnFalsch(new EventArgs());
      }
    }
  }
}